/*----------------------------------------------------------------------

  NotifyHandler.c

  ----------------------------------------------------------------------

  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: NotifyHandler.c,v 1.6 2003/07/20 01:58:37 zxn Exp $

  ----------------------------------------------------------------------*/

#include <PalmOS.h>
#include <string.h>

#include "NotifyHandler.h"
#include "Etc.h"
#include "Prefs.h"
#include "SnapClip.h"

static Err _eventDequedHandler(SysNotifyParamType *notifyP);

/*---------------------------------------------------------------------
  enables hack 
  ----------------------------------------------------------------------*/
void app_enableHack(void)
{
  UInt16 cardNo;
  LocalID dbID;

  SysCurAppDatabase(&cardNo, &dbID);

  /* register to notification */
  SysNotifyRegister (cardNo, 
		     dbID,
		     sysNotifyEventDequeuedEvent,
		     _eventDequedHandler, 
		     sysNotifyNormalPriority, 
		     NULL);
}

/*----------------------------------------------------------------------
  disables hack 
  ----------------------------------------------------------------------*/
void app_disableHack(void)
{
  UInt16 cardNo;
  LocalID dbID;

  SysCurAppDatabase(&cardNo, &dbID);

  /* unregister notification */
  SysNotifyUnregister(cardNo, 
		      dbID,  
		      sysNotifyEventDequeuedEvent, 
		      sysNotifyNormalPriority);
}

/*----------------------------------------------------------------------
  handle eventDequed

#ifdef DEBUG
  debugMessage("eventDequed","",0);
#endif
  ----------------------------------------------------------------------*/
static Err _eventDequedHandler(SysNotifyParamType *notifyP)
{
  EventType event;
  FieldType *field;
  prefsObj prefs;

  /* get event information from notify details */
  memset (&event, 0x0, sizeof(EventType));
  memcpy (&event, notifyP->notifyDetailsP, sizeof(EventType));
  event.eType = SWAP16(event.eType); /* xxx */


  /* quick check */
  if (event.eType != fldEnterEvent && 
      event.eType != tblEnterEvent &&
      event.eType != penMoveEvent && 
      event.eType != penUpEvent)
    return errNone;

  prefs = prefs_New();

  if (prefs_GetFldEnter(prefs) == true) /* pen is entering field*/
    {
      switch (event.eType) 
	{
	case penMoveEvent:
	  prefs_Delete(prefs);
	  return errNone;

	case penUpEvent:
	  if ((field = FrmGetActiveField(FrmGetActiveForm())) != NULL)
	    {
	      UInt16 start, end;

	      FldGetSelection (field, &start, &end);

	      if (start != end)
		EvtEnqueueKey(vchrCommand, 0, commandKeyMask);
	    }

	  prefs_SetFldEnter(prefs, false);
	  break;

	default:
	  prefs_SetFldEnter(prefs, false);
	  break;
	}
    }
  else if (event.eType == fldEnterEvent || event.eType == tblEnterEvent)  
    {
      prefs_SetFldEnter(prefs, true);
    }
  
  prefs_Save(prefs);
  prefs_Delete(prefs);

  return errNone;
}
